﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;
using VeteransAffairs.Registries.BusinessAHOBPR;
using System.Collections.Generic;
using System.Linq;

namespace WCF_BusinessManagerAHOBPRTests
{
    [TestClass]
    public class RegistrantHistoryTests : DeploymentFactoryTestBase
    {
        private RegistrantHistory _cut;
        private MilitaryOccupationHistoryManager _mohMgr;
        [TestInitialize]
        public void Init()
        {
            _cut = new RegistrantHistory();
            _mohMgr = new MilitaryOccupationHistoryManager(sqlConnection);
        }
        [TestMethod]
        public void CreateOccupationsDateRange_Creates_DateRange_For_Each_Occupation()
        {
            _cut.OccupationsByDateTime = CreateEightOccupationHistoryEntries();
            var actual = _cut.OccupationDateTimesByDateRange;
            Assert.AreEqual(8, actual.Keys.Count);
        }
        [TestMethod]
        public void CreateOccupationsDateRange_Given_Only_One_Entry_Creates_DateRange_With_EndDate_Of_DateTimeNOW()
        {
            _cut.OccupationsByDateTime = CreateSingleOccupationHistoryEntry();
            var actual = _cut.OccupationDateTimesByDateRange;
            var expected = new DateRange( DateTime.Parse("3/31/2014 12:00:00 AM"), DateTime.Now);
            Assert.AreEqual(expected.End, actual.Keys.First().End);
        }
        [TestMethod]
        public void CreateOccupationsDateRange_Creates_EndDate()
        {
            _cut.OccupationsByDateTime = CreateTwoOccupationHistoryEntries();
            var actual = _cut.OccupationDateTimesByDateRange;
            var expected = new DateRange(DateTime.Parse("7/31/2012 12:00:00 AM"), DateTime.Parse("3/30/2014 12:00:00 AM") );
            Assert.AreEqual(expected.End, actual.Keys.First().End);
        }

        [TestMethod]
        public void CreateOccupationsDateRange_Creates_StartDate()
        {
            _cut.OccupationsByDateTime = CreateTwoOccupationHistoryEntries();
            var actual = _cut.OccupationDateTimesByDateRange;
            Console.WriteLine($"{ actual.Keys.First().Start}-> {actual[ actual.Keys.First()]} ");
            var expected = new DateRange(DateTime.Parse("7/31/2012 12:00:00 AM"), DateTime.Parse("3/30/2014 12:00:00 AM"));
            Assert.AreEqual(expected.Start, actual.Keys.First().Start);
        }

    
    }
}
